#pragma once

/////////////////////////////////////////////////////////////////////////////
#include "ProfileDll.h"
#include "ConfigNWK.h"
#include "ConfigDlg.h"
#include "resource.h"
#include "afxwin.h"
#include "afxcmn.h"
#include "ConfigNWKDlgList.h"
#include "ListCtrlEx.h"
/////////////////////////////////////////////////////////////////////////////
// Network list Combo Box possible choice
#define kAvailableNetworksList			0
#define kPreferredNetworksList			1
// List control Colums
#define NetworkSimIndexColumn			0
#define NetworkIdColumn					1
#define NetworkShortNameColumn			2
#define NetworkLongNameColumn			3
#define	kNwkColCount					NetworkLongNameColumn + 1

/////////////////////////////////////////////////////////////////////////////
// CConfigPOWDlg dialog
class CConfigNWKDlg : public CConfigDlg
{
	DECLARE_DYNAMIC(CConfigNWKDlg)
private:
	virtual int		GetIconId()		{ return IDI_ICON_NWK; };
public:
	enum { IDD = IDD_DLGCFG_NWK_MAIN };
	CConfigNWKDlg(CConfigNWK* iCfgNWK) : CConfigDlg(CConfigNWKDlg::IDD, theApp.m_hInstance, iCfgNWK){};
	virtual ~CConfigNWKDlg() {};	
protected:
	virtual void DoDataExchange(CDataExchange* pDX)	{ CDialog::DoDataExchange(pDX); };
	DECLARE_MESSAGE_MAP()
public:
	virtual BOOL	OnInitDialog()	{ CDialog::OnInitDialog(); return TRUE; };
	virtual char*	GetName()		{ return "Network";};
	virtual void	UpdateDisplay()	{};
	virtual BOOL	Apply()			{ return TRUE; };
};

/////////////////////////////////////////////////////////////////////////////
// CConfigNWKDlgSettings dialog
class CConfigNWKDlgSettings : public CConfigDlg
{
	DECLARE_DYNAMIC(CConfigNWKDlgSettings)

public:
	CConfigNWKDlgSettings(CConfigNWK* iCfgNWK) : CConfigDlg(CConfigNWKDlgSettings::IDD, theApp.m_hInstance, iCfgNWK){};
	virtual ~CConfigNWKDlgSettings() {};
	virtual void	UpdateDisplay();
	virtual char*	GetName()		{ return "Settings";};
	virtual BOOL	OnInitDialog();
	virtual BOOL	Apply();
	// Dialog Data
	enum { IDD = IDD_DLGCFG_NWK_SETTINGS};

protected:
	virtual void	DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	DECLARE_MESSAGE_MAP()
public:
	CEdit			mSignalLevelEdit;
	CButton			mSigNotDetectableBut;
	CComboBox		mNetNamePresentation;	

	afx_msg void 	OnBnClickedNtwNotDetectableCheck();
};
/////////////////////////////////////////////////////////////////////////////
// CConfigNWKDlgNotifs dialog
class CConfigNWKDlgNotifs : public CConfigDlg
{
	DECLARE_DYNAMIC(CConfigNWKDlgNotifs)

public:
	CConfigNWKDlgNotifs(CConfigNWK* iCfgNWK) : CConfigDlg(CConfigNWKDlgNotifs::IDD, theApp.m_hInstance, iCfgNWK){};
	virtual ~CConfigNWKDlgNotifs() {};
	virtual void	UpdateDisplay();
	virtual char*	GetName()		{ return "Notifications";};
	virtual BOOL	OnInitDialog();
	virtual BOOL	Apply();
	// Dialog Data
	enum { IDD = IDD_DLGCFG_NWK_NOTIFS};

protected:
	virtual void	DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	DECLARE_MESSAGE_MAP()
public:
	CEdit			mCellIdEdit;
	CEdit			mAreaCodeEdit;
	CComboBox		mRegNotifCombo;

	afx_msg void	OnBnClickedSendNotifButton();
};
/////////////////////////////////////////////////////////////////////////////
// CConfigNWKDlgNetworks dialog
class CConfigNWKDlgNetworks : public CConfigDlg
{
	DECLARE_DYNAMIC(CConfigNWKDlgNetworks)

public:
	CConfigNWKDlgNetworks(CConfigNWK* iCfgNWK) : CConfigDlg(CConfigNWKDlgNetworks::IDD, theApp.m_hInstance, iCfgNWK){};
	virtual ~CConfigNWKDlgNetworks() {};
	virtual void	UpdateDisplay();
	virtual char*	GetName()		{ return "Networks";};
	virtual BOOL	OnInitDialog();
	virtual BOOL	Apply();
	// Dialog Data
	enum { IDD = IDD_DLGCFG_NWK_NETWORKS};

protected:
	virtual void	DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	void			FillAvailableNetworksList();
	void			FillPreferredNetworksList();
	int				mAvailCurrentNwkIndex;
	Bool			mNetListChanged;
	DECLARE_MESSAGE_MAP()
public:
	CComboBox		mSelectNetListCombo;
	CComboBox		mNetListSelMode;
	CComboBox		mRegStateCombo;
	CListCtrlEx		mNetworkListCtrl;
	CComboBox		mNetNamePresentation;
	CList<CNwkDesc,CNwkDesc&> mLocalPrefNwkDesc;
	CList<CNwkDesc,CNwkDesc&> mLocalAvailNwkDesc;

	afx_msg void 	OnBnClickedNtwModifyNetListButton();
	afx_msg void 	OnCbnSelchangeNtwNetworkListCombo();
	afx_msg void 	OnCbnSelchangeNtwStateCombo();
	afx_msg void 	OnLvnItemchangedNtwNetworkListList(NMHDR *pNMHDR, LRESULT *pResult);
};
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////